function x=RandNormT(mu, sd, low, high)
%	RandNormT - x=RandNormT(mu, sd, low, high)
%	Draw from a truncated normal distribution
%	Note: mu and sd are the parameters of the normal, not the mean and sd of the truncated distribution
zlow = (low-mu)/sd;
if isinf(high)
	zhigh = inf;
else
	zhigh = (high-mu)/sd;
end
try
	x = mu + sd*RandStdNormT(zlow, zhigh);
catch
	disp(['zlow=' num2str(zlow) ' zhigh=' num2str(zhigh) ' mu=' num2str(mu) ' sd=' num2str(sd)]);
end

